<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EducationBackground extends Model
{
    use HasFactory;

    protected $table = 'education_background';

    protected $primaryKey = 'Education_id';

    protected $fillable = [
        'User_id',
        'Institution',
        'Degree',
        'Field_of_study',
        'Start_date',
        'End_date',
        'Currently_studying',
        'Description',
    ];

    protected $casts = [
        'Start_date' => 'date',
        'End_date' => 'date',
        'Currently_studying' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }
}
